<?php
/**
 * Demo Import Data
 * @package evockans
 */

if ( did_action( 'elementor/loaded' ) ) {
    function themesflat_import_files() {
        return array(
            array(
                'import_file_name'           => 'Import Demo Elementor Page Builder',
                'import_file_url'            => esc_url(THEMESFLAT_LINK.'demo/demo-elementor/content_elementor.xml'),
                'import_widget_file_url'     => esc_url(THEMESFLAT_LINK.'demo/demo-elementor/widgets_elementor.wie'),
                'import_customizer_file_url' => esc_url(THEMESFLAT_LINK.'demo/demo-elementor/options_elementor.dat'),
                'import_preview_image_url'   => esc_url(THEMESFLAT_LINK.'screenshot.png'),
                'import_notice'              => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'zingbox' ),
                'preview_url'                => esc_url('https://evockans.demothemesflat.com'),
            ),
        );
    }
    add_filter( 'pt-ocdi/import_files', 'themesflat_import_files' );

    function themesflat_before_content_import() { 
        $pages = get_posts(array( 'post_type' => 'page','numberposts' => -1));    
        foreach ( $pages as $page ) {
            wp_delete_post( $page->ID, true);
        }
        $posts = get_posts(array( 'post_type' => 'post','numberposts' => -1));
        foreach ( $posts as $posts ) {
            wp_delete_post( $posts->ID, true);
        }   

        global $wp_registered_sidebars;
        $widgets = get_option('sidebars_widgets');
        foreach ($wp_registered_sidebars as $sidebar => $value) {
            unset($widgets[$sidebar]);
        }
        update_option('sidebars_widgets',$widgets);
    }
    add_action( 'pt-ocdi/before_content_import', 'themesflat_before_content_import' );

    function themesflat_after_import_setup( $selected_import ) {
        $main_menu = get_term_by( 'name', 'Main', 'nav_menu' );
        $footer_menu = get_term_by( 'name', 'Menu Footer', 'nav_menu' );
        $bottom_menu = get_term_by( 'name', 'Menu Bottom', 'nav_menu' );

        set_theme_mod( 'nav_menu_locations', array(
                'primary' => $main_menu->term_id,
                'footer' => $footer_menu->term_id,
                'bottom' => $footer_menu->term_id
            )
        );

        $front_page = get_page_by_title( 'Multi-purpose Agency' );        
        $blog_page  = get_page_by_title( 'Blog List' );
        update_option( 'show_on_front', 'page' );
        update_option( 'page_on_front', $front_page->ID );
        update_option( 'page_for_posts', $blog_page->ID );
        update_option( 'posts_per_page', 3 ); 

        global $wp_rewrite;
        $wp_rewrite->set_permalink_structure('/%postname%/');
        $wp_rewrite->flush_rules();

        update_option( "elementor_disable_color_schemes", "yes" );
        update_option( "elementor_disable_typography_schemes", "yes" );
        $default_colors = array();
        $default_colors[1] = "#2387EA";
        $default_colors[2] = "#252525";
        $default_colors[3] = "#999999";
        $default_colors[4] = "#FFFFFF";
        $default_colors[5] = "#FAFAFA";
        $default_colors[6] = "#222222";
        $default_colors[7] = "#888888";
        $default_colors[8] = "#121212";
        $default_colors[9] = "#AAAAAA33";
        $default_colors[10] = "#EDEFF1";
        $default_colors[11] = "#AAAAAA";
        $default_colors[12] = "#EEEEEE";
        $default_colors[13] = "#666666";
        $default_colors[14] = "#000000";
        $default_colors[15] = "#A1A2A1";
        $default_colors[16] = "#FFB432";
        $default_colors[17] = "#797979";
        update_option( "elementor_scheme_color", $default_colors );
        update_option( "elementor_scheme_color_picker", $default_colors );
    }
    add_action( 'pt-ocdi/after_import', 'themesflat_after_import_setup' );

    function themesflat_import_revsliders( $selected_import ) {
        if ( class_exists( 'RevSlider' ) ) {
            $slider_array = array(
                THEMESFLAT_DIR . '/demo/demo-elementor/slide-1.zip',
                THEMESFLAT_DIR . '/demo/demo-elementor/slide-2.zip',
                THEMESFLAT_DIR . '/demo/demo-elementor/slide-3.zip',
                THEMESFLAT_DIR . '/demo/demo-elementor/slide-4.zip',
                THEMESFLAT_DIR . '/demo/demo-elementor/home-hero.zip'
            );
            $slider = new RevSlider();       
            foreach($slider_array as $filepath){
                $slider->importSliderFromPost(true,true,$filepath);  
            }       
            return 'Revolution Slider imported';
        }
    }
    add_action( 'pt-ocdi/after_import', 'themesflat_import_revsliders' );
}else if( function_exists( 'visual_composer' ) ) {
    function themesflat_import_files() { 
        return array(
            array(
                'import_file_name'             => 'Multi-purpose Agency',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_demo1.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p1.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => esc_url('https://surielementor.com/evockans/multi-purpose-agency/'),
            ),

            array(
                'import_file_name'             => 'Consulting Agency',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_demo2.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p2.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => esc_url('https://surielementor.com/evockans/consulting-agency'),
            ),

            array(
                'import_file_name'             => 'Corporate Agency',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_demo3.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p3.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => esc_url('https://surielementor.com/evockans/corporate-agency'),
            ),

            array(
                'import_file_name'             => 'Finance Agency',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_demo4.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p4.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => THEMESFLAT_LINK.'finance-agency',
            ),

            array(
                'import_file_name'             => 'Classic Business Agency',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_demo5.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p5.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => esc_url('https://surielementor.com/evockans/classic-business-agency'),
            ),

            array(
                'import_file_name'             => 'Marketing Agency',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_demo6.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p6.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => esc_url('https://surielementor.com/evockans/marketing-agency'),
            ),

            array(
                'import_file_name'             => 'Startup',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_demo7.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p7.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => esc_url('https://surielementor.com/evockans/startup'),
            ),

            array(
                'import_file_name'             => 'Web Agency',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_demo8.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p8.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => esc_url('https://surielementor.com/evockans/web-agency'),
            ),

            array(
                'import_file_name'             => 'Digital Agency',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_demo9.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p9.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => esc_url('https://surielementor.com/evockans/digital-agency'),
            ),

            array(
                'import_file_name'             => 'Creative Agency',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_demo10.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p10.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => esc_url('https://surielementor.com/evockans/creative-agency'),
            ),

            array(
                'import_file_name'             => 'Creative Studio',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_demo11.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p11.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => esc_url('https://surielementor.com/evockans/creative-studio'),
            ),

            array(
                'import_file_name'             => 'Modern Agency',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_demo12.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p12.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => esc_url('https://surielementor.com/evockans/modern-agency'),
            ),

            array(
                'import_file_name'             => 'Small Business',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_demo13.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p13.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => esc_url('https://surielementor.com/evockans/small-business'),
            ),

            array(
                'import_file_name'             => 'SEO Agency',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_demo14.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p14.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => esc_url('https://surielementor.com/evockans/seo-agency'),
            ),

            array(
                'import_file_name'             => 'Digital Product',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_demo15.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p15.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => esc_url('https://surielementor.com/evockans/digital-product'),
            ),

             array(
                'import_file_name'             => 'Home Hero',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_demo16.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p16.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => esc_url('https://surielementor.com/evockans/home-hero'),
            ),

            array(
                'import_file_name'             => 'All Demo',
                'import_file_url'              => THEMESFLAT_LINK.'demo/demo-vc/content_full.xml',
                'import_widget_file_url'       => THEMESFLAT_LINK.'demo/widgets.wie',
                'import_customizer_file_url'   => THEMESFLAT_LINK.'demo/options.dat',
                'import_preview_image_url'     => THEMESFLAT_LINK.'demo/p1.png',
                'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'evockans' ),
                'preview_url'                  => esc_url('https://surielementor.com/evockans/'),
            ),
        );
    }
    add_filter( 'pt-ocdi/import_files', 'themesflat_import_files' );

    function themesflat_before_content_import() { 
        $pages = get_posts(array( 'post_type' => 'page','numberposts' => -1));    
        foreach ( $pages as $page ) {
            wp_delete_post( $page->ID, true);
        }
        $posts = get_posts(array( 'post_type' => 'post','numberposts' => -1));
        foreach ( $posts as $posts ) {
            wp_delete_post( $posts->ID, true);
        }   

        global $wp_registered_sidebars;
        $widgets = get_option('sidebars_widgets');
        foreach ($wp_registered_sidebars as $sidebar => $value) {
            unset($widgets[$sidebar]);
        }
        update_option('sidebars_widgets',$widgets);
    }
    add_action( 'pt-ocdi/before_content_import', 'themesflat_before_content_import' );

    function themesflat_after_import_setup( $selected_import ) {
        $main_menu = get_term_by( 'name', 'Main', 'nav_menu' );
        $footer_menu = get_term_by( 'name', 'Menu Footer', 'nav_menu' );
        $bottom_menu = get_term_by( 'name', 'Menu Bottom', 'nav_menu' );

        set_theme_mod( 'nav_menu_locations', array(
                'primary' => $main_menu->term_id,
                'footer' => $footer_menu->term_id,
                'bottom' => $footer_menu->term_id,
            )
        );

        if ( 'Multi-purpose Agency' === $selected_import['import_file_name'] ) { 
            $front_page = get_page_by_title( 'Multi-purpose Agency' ); 
        } elseif ('Consulting Agency' === $selected_import['import_file_name']) {
            $front_page = get_page_by_title( 'Consulting Agency' );
        } elseif ('Corporate Agency' === $selected_import['import_file_name']) {
            $front_page = get_page_by_title( 'Corporate Agency' );
        } elseif ('Finance Agency' === $selected_import['import_file_name']) {
            $front_page = get_page_by_title( 'Finance Agency' );
        } elseif ('Classic Business Agency' === $selected_import['import_file_name']) {
            $front_page = get_page_by_title( 'Classic Business Agency' );
        } elseif ('Marketing Agency' === $selected_import['import_file_name']) {
            $front_page = get_page_by_title( 'Marketing Agency' );
        } elseif ('Startup' === $selected_import['import_file_name']) {
            $front_page = get_page_by_title( 'Startup' );
        } elseif ('Web Agency' === $selected_import['import_file_name']) {
            $front_page = get_page_by_title( 'Web Agency' );
        } elseif ('Digital Agency' === $selected_import['import_file_name']) {
            $front_page = get_page_by_title( 'Digital Agency' );
        } elseif ('Creative Agency' === $selected_import['import_file_name']) {
            $front_page = get_page_by_title( 'Creative Agency' );
        } elseif ('Creative Studio' === $selected_import['import_file_name']) {
            $front_page = get_page_by_title( 'Creative Studio' );
        } elseif ('Modern Agency' === $selected_import['import_file_name']) {
            $front_page = get_page_by_title( 'Modern Agency' );
        } elseif ('Small Business' === $selected_import['import_file_name']) {
            $front_page = get_page_by_title( 'Small Business' );
        } elseif ('SEO Agency' === $selected_import['import_file_name']) {
            $front_page = get_page_by_title( 'SEO Agency' );       
        } elseif ('Digital Product' === $selected_import['import_file_name']) {
            $front_page = get_page_by_title( 'Digital Product' );
        }elseif ('Home Hero' === $selected_import['import_file_name']) {
            $front_page = get_page_by_title( 'Home Hero' );
        } elseif ('All Demo' === $selected_import['import_file_name']) {
            $front_page = get_page_by_title( 'Multi-purpose Agency' );
        } 
        
        $blog_page  = get_page_by_title( 'Blog List' );
        update_option( 'page_on_front', $front_page->ID );
        update_option( 'page_for_posts', $blog_page->ID );
        update_option( 'posts_per_page', 3 ); 

        global $wp_rewrite;
        $wp_rewrite->set_permalink_structure('/%postname%/');
        $wp_rewrite->flush_rules();         

    }
    add_action( 'pt-ocdi/after_import', 'themesflat_after_import_setup' );

    function themesflat_import_revsliders( $selected_import ) {        
        if ( 'Multi-purpose Agency' === $selected_import['import_file_name'] ) { 

            if ( class_exists( 'RevSlider' ) ) {
                $slider_array = array(
                    THEMESFLAT_DIR . '/demo/slide-1.zip'
                );
                $slider = new RevSlider();       
                foreach($slider_array as $filepath){
                    $slider->importSliderFromPost(true,true,$filepath);  
                }       
                return 'Revolution Slider imported';
            }

        } elseif ('Consulting Agency' === $selected_import['import_file_name']) {
            
            if ( class_exists( 'RevSlider' ) ) {
                $slider_array = array(
                    THEMESFLAT_DIR . '/demo/slide-2.zip'
                );
                $slider = new RevSlider();       
                foreach($slider_array as $filepath){
                    $slider->importSliderFromPost(true,true,$filepath);  
                }       
                return 'Revolution Slider imported';
            }

        } elseif ('Corporate Agency' === $selected_import['import_file_name']) {
            
            if ( class_exists( 'RevSlider' ) ) {
                $slider_array = array(
                    THEMESFLAT_DIR . '/demo/slide-2.zip'
                );
                $slider = new RevSlider();       
                foreach($slider_array as $filepath){
                    $slider->importSliderFromPost(true,true,$filepath);  
                }       
                return 'Revolution Slider imported';
            }

        } elseif ('Finance Agency' === $selected_import['import_file_name']) {
            
            if ( class_exists( 'RevSlider' ) ) {
                $slider_array = array(
                    THEMESFLAT_DIR . '/demo/slide-3.zip'
                );
                $slider = new RevSlider();       
                foreach($slider_array as $filepath){
                    $slider->importSliderFromPost(true,true,$filepath);  
                }       
                return 'Revolution Slider imported';
            }

        } elseif ('Classic Business Agency' === $selected_import['import_file_name']) {
            
            if ( class_exists( 'RevSlider' ) ) {
                $slider_array = array(
                    THEMESFLAT_DIR . '/demo/slide-1.zip'
                );
                $slider = new RevSlider();       
                foreach($slider_array as $filepath){
                    $slider->importSliderFromPost(true,true,$filepath);  
                }       
                return 'Revolution Slider imported';
            }

        } elseif ('Web Agency' === $selected_import['import_file_name']) {
           
            if ( class_exists( 'RevSlider' ) ) {
                $slider_array = array(
                    THEMESFLAT_DIR . '/demo/slide-2.zip'
                );
                $slider = new RevSlider();       
                foreach($slider_array as $filepath){
                    $slider->importSliderFromPost(true,true,$filepath);  
                }       
                return 'Revolution Slider imported';
            }

        } elseif ('Digital Agency' === $selected_import['import_file_name']) {
            
            if ( class_exists( 'RevSlider' ) ) {
                $slider_array = array(
                    THEMESFLAT_DIR . '/demo/slide-1.zip'
                );
                $slider = new RevSlider();       
                foreach($slider_array as $filepath){
                    $slider->importSliderFromPost(true,true,$filepath);  
                }       
                return 'Revolution Slider imported';
            }

        } elseif ('Creative Agency' === $selected_import['import_file_name']) {
           
            if ( class_exists( 'RevSlider' ) ) {
                $slider_array = array(
                    THEMESFLAT_DIR . '/demo/slide-1.zip'
                );
                $slider = new RevSlider();       
                foreach($slider_array as $filepath){
                    $slider->importSliderFromPost(true,true,$filepath);  
                }       
                return 'Revolution Slider imported';
            }

        } elseif ('Creative Studio' === $selected_import['import_file_name']) {
            
            if ( class_exists( 'RevSlider' ) ) {
                $slider_array = array(
                    THEMESFLAT_DIR . '/demo/slide-2.zip'
                );
                $slider = new RevSlider();       
                foreach($slider_array as $filepath){
                    $slider->importSliderFromPost(true,true,$filepath);  
                }       
                return 'Revolution Slider imported';
            }

        } elseif ('SEO Agency' === $selected_import['import_file_name']) {
            
            if ( class_exists( 'RevSlider' ) ) {
                $slider_array = array(
                    THEMESFLAT_DIR . '/demo/slide-2.zip'
                );
                $slider = new RevSlider();       
                foreach($slider_array as $filepath){
                    $slider->importSliderFromPost(true,true,$filepath);  
                }       
                return 'Revolution Slider imported';
            } 

        }elseif ('Home Hero' === $selected_import['import_file_name']) {
            
            if ( class_exists( 'RevSlider' ) ) {
                $slider_array = array(
                    THEMESFLAT_DIR . '/demo/home-hero.zip'
                );
                $slider = new RevSlider();       
                foreach($slider_array as $filepath){
                    $slider->importSliderFromPost(true,true,$filepath);  
                }       
                return 'Revolution Slider imported';
            } 

        } elseif ('All Demo' === $selected_import['import_file_name']) {
            
            if ( class_exists( 'RevSlider' ) ) {
                $slider_array = array(
                    THEMESFLAT_DIR . '/demo/slide-1.zip',
                    THEMESFLAT_DIR . '/demo/slide-2.zip',
                    THEMESFLAT_DIR . '/demo/slide-3.zip'
                );
                $slider = new RevSlider();       
                foreach($slider_array as $filepath){
                    $slider->importSliderFromPost(true,true,$filepath);  
                }       
                return 'Revolution Slider imported';
            }

        }       
    }
    add_action( 'pt-ocdi/after_import', 'themesflat_import_revsliders' );
}