<?php
/**
 * Return the default options of the theme
 * 
 * @return  void
 */

function themesflat_customize_default($key) {
	$default = array(
		'logo_controls' => array('padding-top' => 25,'padding-left' => ''),
		'footer_controls' => array('padding-top' => 70,'padding-bottom' => 54),
		'bread_crumb_prefix' =>'',
		'bottom_style' => 'bottom-center',
		'breadcrumb_separator' =>  '<i class="fa fa-angle-right" aria-hidden="true"></i>',
		'footer_style' => 1,
		'footer_widget_areas' => 4,
		'show_post_navigator' => 0,
		'show_entry_footer_content'	=> 0,
		'breadcrumb_prefix' => '',
		'logo_width' => 186,
		'menu_location_primary' => 'primary',
		'site_logo'	=> THEMESFLAT_LINK . 'images/logo.png',
		'site_retina_logo' => THEMESFLAT_LINK . 'images/logo@2x.png',
		'site_logo_sticky'	=> THEMESFLAT_LINK . 'images/logo.png',
		'site_retina_logo_sticky' => THEMESFLAT_LINK . 'images/logo@2x.png',
		'social_links'	=> array ("facebook" => '#', "twitter" => '#', "linkedin" => '#', "pinterest" => '#'),
		'page_title_background_color' => 'rgba(0,0,0,0.2)',
		'page_title_text_color' => '#ffffff',
		'page_title_link_color' => 'rgba(255,255,255,0.5)',
		'page_title_controls' => array('padding-top' => 124, 'padding-bottom' => 130, 'margin-bottom' => 90),
		'page_title_background_image' => '',
		'page_title_image_size' => 'auto',
		'show_footer' => 1,
		'footer1' => 'footer-1',
		'footer2' => 'footer-2',
		'footer3' => 'footer-3',
		'footer4' => 'footer-4',
		'footer5' => 'footer-5',
		'footers21' => 'footers2-1',
		'footers22' => 'footers2-2',
		'footers23' => 'footers2-3',
		'footers24' => 'footers2-4',
		'footers25' => 'footers2-5',
		'footers31' => 'footers3-1',
		'footers32' => 'footers3-2',
		'footers33' => 'footers3-3',
		'footers34' => 'footers3-4',
		'footers35' => 'footers3-5',
		'footers41' => 'footers4-1',
		'footers42' => 'footers4-2',
		'footers43' => 'footers4-3',
		'footers44' => 'footers4-4',
		'footers45' => 'footers4-5',
		'show_menu_bottom' => 0,
		'enable_socials_link_top'  => 0,
		'search_top' => 0,
		'logo_margin_left' 	  => 0,
		'show_page_title'	  => 1,
		'show_page_title_heading' => 1,
		'portfolio_show_information' => 1,
		'portfolio_show_post_navigator' => 0,
		'service_show_information' => 1,
		'service_show_post_navigator' => 0,
		'top_background_color'	=> '#ffffff',
		'topbar_textcolor'	=> '#aaaaaa',
		'topbar_bordercolor'	=> 'rgba(170,170,170,0.2)',
		'mainnav_backgroundcolor'=>'#ffffff',
		'mainnav_backgroundcolor_sticky'=>'#ffffff',
		'mainnav_color'		=> '#252525',
		'mainnav_hover_color'=>'#2387ea',
		'sub_nav_color'		=>'#70798b',
		'sub_nav_background'=>'#ffffff',
		'sub_nav_color_hover'	=>	'#2387ea',
		'border_color_sub_nav'=>'#ffffff',
		'sub_nav_background_hover'=>'#ffffff',
		'primary_color'=>'#2387ea',
		'body_text_color'=>'#999999',
		'body_background_color' => '',
		'body_font_name'	=> array(
			'family' => 'Open Sans',
			'style'  => 'regular',
			'size'   => '14',
			'line_height'=>'25px'
			),
		'menu_font_name'	=> array(
			'family' => 'Open Sans',
			'style'  => '600',
			'size'   => '14',
			'line_height'=>'90px',
		), 
		'headings_font_name'	=> array(
			'family' => 'Open Sans',
			'style'  => '600'			
			),
		'h1_size' => 36,
		'h2_size' => 30,
		'h3_size' => 25,
		'h4_size' => 22,
		'h5_size' => 18,
		'h6_size' => 15,		
		'style_header'	=> 'header-style1',		
		'breadcrumb_enabled' => 1,
		'show_post_paginator' => 0,
		'blog_grid_columns' => 2,
		'blog_archive_exclude' => '',
		'testimonial_rating' => 0,
		'blog_layout' => 'sidebar-right',
		'page_layout' => 'fullwidth',
		'blog_archive_layout' => 'blog-list',
		'related_post_style'	=> 'blog-grid',
		'blog_sidebar_list'		  => 'blog-sidebar',	
		'blog_archive_readmore' => 1,
		'blog_archive_post_excepts_length' => 64,
		'blog_archive_readmore_text' => 'Read More',
		'blog_archive_pagination_style' => 'pager-numeric',
		'blog_posts_per_page'	=> 3,
		'blog_order_by'	=> 'date',
		'blog_order_direction' => 'DESC',
		'page_sidebar_list'	=> 'blog-sidebar',		
		'show_readmore'	  => 1,
		'grid_columns_portfolio' => 'one-three',
		'portfolio_exclude' =>'',
		'portfolios_sidebar'		=> 'fullwidth',
		'portfolio_category_order' => '',
		'related_portfolio_style' => 'grid',
		'grid_columns_portfolio_related' => 3,
		'number_related_portfolio' => 9,
		'show_related_portfolio' => 0,
		'services_grid_columns' => 'columns-4',
		'services_show_post_navigator' => 1,
		'services_post_perpage' => -1,		
		'enable_custom_topbar'  => 0,
		'enable_page_callout'	=> 0,
		'topbar_show' => 0,
		'header_sticky' => 1,
		'header_search_box' => 1,
		'header_button'	=> 0,
		'header_button_text'	=> '<i class="icon_phone"></i> Call Now',
		'header_button_link'	=> '#',
		'header_color_btn'	=> '#ffffff',
		'header_bg_btn'	=> '#2387ea',
		'header_color_btn_hover'	=> '#ffffff',
		'header_bg_btn_hover'	=> '#222222',		
		'footer_background_color'	=> '#121212',
		'footer_text_color'			=> '#ffffff',
		'footer_background_image'	=> '',
		'footer_image_size'			=> 'auto',
		'bottom_background_color'	=> '#222222',
		'bottom_text_color'			=> '#ffffff',
		'go_top'					=> 1,
		'layout_version'			=> 'wide',		
		'footer_copyright'			=> '<p>Copyright © 2020. All Rights Reserved.</p>',
		'top_content' => '<ul class="flat-information">
                            <li><i class="fas fa-map-marker-alt"></i><a href="#">New York, NY Sheram 113</a></li>
                            <li><i class="fas fa-phone-square"></i><a href="#">Phone: +1-23-456789</a></li>
                            <li><i class="fa fa-envelope"></i><a href="#">Email: example@email.com</a></li>
                        </ul>',
		'show_header_content' => 0,
		'enable_smooth_scroll'	=> 0,
		'show_social_share'	=> 0,
		'show_content' => 1,
		'show_date_portfolio' => 0,
		'show_readmore_portfolio' => 0,
		'show_content_portfolio' => 0,
		'portfolio_content_length' => 150,
		'header_absolute'	=> 0,
		'topbar_absolute'	=> 0,
		'page_title_styles' => 'parallax',
		'page_title_alignment' => 'center',
		'page_title_video_url' => PROTOCOL . '://www.youtube.com/watch?v=JyMeGpvpjas',
		'enable_preload'	=> 1,
		'preload' => 'preload-1',
		'show_action_box'	=> 0,
		'text_action_box'	=>	'<h3 class="heading">Create awesome web sites with us!</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt.</p> ',
        'text_button_action_box'	=> 'Read More',
        'link_button_action_box' => '#',
        'action_box_background_color' => '#fafafa',
        'action_box_heading_color' => '#222222',
        'action_box_text_color'	=> '#999999',
        'action_box_button_text_color' => '#ffffff',
        'action_box_button_background_color' => '#2387ea',
        'page_404_style' => 'page-404-style2',
        'page_404_bg_video_url' => PROTOCOL . '://corpthemes.com/wordpress/evockans/demo/Videos.mp4',
        'comming_soon_time' => '2022/01/01',
        'bg_img_comming_soon' => THEMESFLAT_LINK . 'images/comming-soon.png',
        'comming_soon_background_color' => '',
	);
	return $default[$key];
}